<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Car extends Model 
{

    protected $table = 'cars';
    public $timestamps = true;
    protected $fillable = array('front_license', 'back_license', 'image', 'type', 'brand', 'model', 'color', 'car_num', 'salaryPerKilo', 'driver_id');

    public function driver()
    {
        return $this->belongsTo('App\Models\Driver');
    }

    public function trips()
    {
        return $this->hasMany('App\Models\Trip');
    }

    public function tracker()
    {
        return $this->hasOne('App\Models\Tracker');
    }

}